// DOSingleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DOSingle.h"
#include "DOSingleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDOSingleDlg dialog

CDOSingleDlg::CDOSingleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDOSingleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDOSingleDlg)
	m_DOValue = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDOSingleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDOSingleDlg)
	DDX_Control(pDX, IDC_WRITEDO, m_writedoButton);
	DDX_Text(pDX, IDC_DOVALUE, m_DOValue);
	DDV_MinMaxUInt(pDX, m_DOValue, 0, 15);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDOSingleDlg, CDialog)
	//{{AFX_MSG_MAP(CDOSingleDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_INIT, OnInit)
	ON_BN_CLICKED(IDC_WRITEDO, OnWriteDO)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDOSingleDlg message handlers

BOOL CDOSingleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_driverInstance = NULL;
	m_pSR = NULL;
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDOSingleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDOSingleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDOSingleDlg::OnClose() 
{
	// code to clean up after DriverLINX
	if (m_driverInstance != NULL)
	{
     CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
     m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
	}
	if (m_pSR != NULL)
	{
      delete(m_pSR); //de-allocate the memory used by the service request
      m_pSR=NULL;
	}
	
	CDialog::OnClose();
}

void CDOSingleDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
	return;
}

void CDOSingleDlg::OnInit() 
{
		// Open the driver and Initialize the hardware
m_pSR=NULL;
m_driverInstance=NULL;
// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance=OpenDriverLINX(m_hWnd,"kmb1800"); //use KMB1700 for DAS-1700 boards
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
m_pSR->device=0; //set the device number used in DLinx Config Panel
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application

if (DriverLINX(m_pSR) == NoErr)  // execute the task
{  // success
m_writedoButton.EnableWindow(TRUE);  // enable the Write button
}
else  // problem has occured
{  showMessage(m_pSR);}  // display the error message box

CWnd::SetActiveWindow();  // set focus back to our dialog	
}

void CDOSingleDlg::OnWriteDO() 
{
	// bring in the data from the text box on the dialog
    UpdateData(TRUE); // update from the Dialog
	m_pSR->status.u.ioValue = m_DOValue;  // a value between 0 and 15
// most DAS-1800 boards have only 4 bits of output...except the DAS-180xHC boards
// which have 8 bits.


	/*
      The status.u.ioValue member of the SR structure can host single value
	  inputs or outputs.  No need to allocate and use a Buffer for single
	  value reads/writes.
  */
// setup a single channel, polled mode DO task
	m_pSR->device = 0;
	m_pSR->hWnd = m_hWnd;
	m_pSR->mode = POLLED;  // foreground operation
	m_pSR->operation = START; 
	m_pSR->subsystem = DO;  // use DO subsystem of board
	m_pSR->start.typeEvent = COMMAND;  // start when DriverLINX function is called
	m_pSR->stop.typeEvent = TCEVENT;   // stop automatically
	m_pSR->timing.typeEvent = NULLEVENT;  // if POLLED no timing required
	m_pSR->channels.nChannels = 1;        // only the start channel specified
	m_pSR->channels.chanGain[0].channel = 0; // use chan 0
	m_pSR->channels.numberFormat = tNATIVE;
	if (DriverLINX(m_pSR) != NoErr)  // execute the task
	{  // problem has occured
     showMessage(m_pSR);  // display the error message box
	}
	
}


/*
  Check your hardware specifications.  Some boards have digital channels
 with fixed direction (input or output).  DAS-xxxx and many of the special
 purpose digital I/O such as PDISO-8, PIO-32, REL-16, etc.  For these boards,
 configuration of a fixed output channel for output is not necessary and will 
 raise an error.

 Many boards, however, have general purpose digital I/O.  This is true of
 the PIO-12, PIO-24, KPCI-PIOxx, KPCI-3160 and most of the KPCI multifunction
 boards.  Digital ports on these boards initialize as input channels.
 To use them as outputs, they must first be configured for output direction.

 KPCI-3108/7 has a fixed DO channel 0 and a fixed DI channel 0 on main (upper)
 I/O connector.  The 4 digital channels (1 to 4) on second connector are inputs
 by defult and configurable for output.

 If the configuration step is not carried out, an "invalid channel in channel/gain
 list" error message will occur when trying to write to the digital channel.  Assign
 the channel to DO subsystem with a CONFIGURE task to avoid this error.

 The code below shows how to carry out a config operation in the case that 
 the digital channel in use is configurable.

	m_pSR->hWnd=m_hWnd;
	m_pSR->device=0;
	m_pSR->operation=CONFIGURE;
	m_pSR->subsystem=DO;  // make this DI to assign the channel to DI subsystem
	m_pSR->mode=OTHER;
	m_pSR->timing.typeEvent = DIOSETUP;
    m_pSR->timing.u.diSetup.channel = 0;  // the digial channel to configure
    m_pSR->timing.u.diSetup.mode = DIO_BASIC;
	if (DriverLINX(m_pSR) == NoErr)  // execute the task
{  // success

}
else  // problem has occured
{  showMessage(m_pSR);}  // display the error message box
}
*/